VERSION 5.00
Object = "{1C98F15C-068A-11D4-98C2-00108301CB39}#2.0#0"; "AGT3494A.OCX"
Begin VB.Form frmMonitor 
   Caption         =   "Form1"
   ClientHeight    =   2925
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6450
   LinkTopic       =   "Form1"
   ScaleHeight     =   2925
   ScaleWidth      =   6450
   StartUpPosition =   3  'Windows Default
   Begin Agt3494ALib.Agt3494A Agt3494A1 
      Left            =   240
      Top             =   120
      _ExtentX        =   953
      _ExtentY        =   847
      Address         =   "GPIB0::9"
   End
   Begin VB.CommandButton cmdSetIO 
      Caption         =   "Set IO"
      Height          =   495
      Left            =   4680
      TabIndex        =   7
      Top             =   120
      Width           =   1575
   End
   Begin VB.Frame Frame1 
      Caption         =   "Monitor"
      Height          =   1935
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   6255
      Begin VB.TextBox txtMonitor 
         Height          =   1095
         Left            =   3720
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   4
         Top             =   480
         Width           =   2415
      End
      Begin VB.CommandButton cmdRefreshChannels 
         Caption         =   "Refresh Channels"
         Height          =   495
         Left            =   2040
         TabIndex        =   3
         Top             =   1080
         Width           =   1455
      End
      Begin VB.CommandButton cmdMonitor 
         Caption         =   "Monitor"
         Enabled         =   0   'False
         Height          =   495
         Left            =   2040
         TabIndex        =   2
         Top             =   480
         Width           =   1455
      End
      Begin VB.ListBox lstChannel 
         Height          =   1035
         ItemData        =   "monitor34970.frx":0000
         Left            =   240
         List            =   "monitor34970.frx":0007
         TabIndex        =   1
         Top             =   480
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   "Select channel"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   240
         Width           =   1575
      End
      Begin VB.Label Label2 
         Caption         =   "Channel   Reading"
         Height          =   255
         Left            =   3720
         TabIndex        =   5
         Top             =   240
         Width           =   2055
      End
   End
End
Attribute VB_Name = "frmMonitor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
''' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'''  Copyright  2001 Agilent Technologies Inc.  All rights reserved.
'''
''' You have a royalty-free right to use, modify, reproduce and distribute
''' the Sample Application Files (and/or any modified version) in any way
''' you find useful, provided that you agree that Agilent Technologies has no
''' warranty,  obligations or liability for any Sample Application Files.
'''
''' Agilent Technologies provides programming examples for illustration only,
''' This sample program assumes that you are familiar with the programming
''' language being demonstrated and the tools used to create and debug
''' procedures. Agilent Technologies support engineers can help explain the
''' functionality of Agilent Technologies software components and associated
''' commands, but they will not modify these samples to provide added
''' functionality or construct procedures to meet your specific needs.
''' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
'' This example demonstrates how to read the scan list, and how to monitor
'' a channel that is on the scan list.
'' To monitor a scan list first set up one or more channels on the 34970a manually.
''
'' The example also demonstrates how to query the instrument for instrument
'' errors.

Private Sub cmdMonitor_Click()
    Dim channel As String

    If isconnected Then
        channel = MonitorChannel
        Monitor Agt3494A1, txtMonitor, channel
        InstrumentError Agt3494A1
    End If

End Sub


Private Sub cmdRefreshChannels_Click()
    ' gets the scan list from instrument
    ' and checks instrument for errors

    Me.MousePointer = vbHourglass

    If isconnected Then

        GetScanList Agt3494A1, lstChannel
        InstrumentError Agt3494A1
    End If
    
    Me.cmdMonitor.Enabled = True

    Me.MousePointer = vbDefault

End Sub

Private Sub cmdSetIO_Click()
    Agt3494A1.ShowConnectDialog
End Sub
Private Function MonitorChannel() As String
    ' returns the user selected channel to monitor
    Dim index As Long

    With lstChannel
        index = .ListIndex
        If index > 0 Then
            MonitorChannel = Right$(.List(index), 3)
        Else
            MonitorChannel = "Front Panel"
            Exit Function
        End If
    End With

End Function



'"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
Private Function isconnected() As Boolean
    ' determines if the instrument is connected, and
    ' gives a message if not
    ' Checks to make sure the instrument is a 34970a
    Dim result(4) As String
    Dim oldTimeout As Long

    On Error GoTo connectError

    With Agt3494A1
        ' use a very short timeout so we don't have to wait long
        ' if there is an error
        oldTimeout = .Timeout
        .Timeout = 1000
        .Output "*IDN?"
        .Enter result
        .Timeout = oldTimeout
    End With

    If InStr(1, result(1), "34970A", vbTextCompare) = 0 Then
        GoTo WrongInstrumentError
    End If

    isconnected = True

    Exit Function

connectError:
    Agt3494A1.Timeout = 10000
    MsgBox "Instrument not connected. Please check connections and use the Set I/O toolbar button to set the instrument connection."
    isconnected = False
    Exit Function
WrongInstrumentError:
    MsgBox "Incorrect instrument: " & vbCrLf & _
            "Expected 34970A " & vbCrLf & _
            "Instrument discovered: " & result(1)
    isconnected = False
End Function

Public Sub InstrumentError(Agt3494A1 As Agt3494A)
    ' retrieves the instrument error and displays a messageBox
    ' if there is an error.
    Dim reply As String

    With Agt3494A1
        .Output "Syst:Error?"
        .Enter reply
    End With

    If Val(reply) <> 0 Then
        MsgBox "Instrument Error: " & vbCrLf & reply, vbCritical
        InstrumentError Agt3494A1
    End If

End Sub


